﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Web.Script.Serialization;
using VIRP.AHOBPR.BO;

namespace VIRP.AHOBPR.BLL
{
    public class AnswerJavaScriptConverter : JavaScriptConverter
    {
        private static readonly Type[] _supportedTypes = new[] { typeof(BprAnswer) };
        //private AHOBPRShared _sharedManager = new AHOBPRShared();
        public override IEnumerable<Type> SupportedTypes
        {
            get { return _supportedTypes; }
        }

        public override object Deserialize(
            IDictionary<string, object> dictionary,
            Type type,
            JavaScriptSerializer serializer)
        {
            if (type == typeof(BprAnswer))
            {
                var obj = new BprAnswer();

                // From data migration:
                if (dictionary.ContainsKey("answerValue"))
                {
                    if (dictionary["answerValue"] is ArrayList && dictionary["answerValue"] != null)
                        obj.answerValues = serializer.ConvertToType<string[]>(dictionary["answerValue"]);
                    else
                        obj.answerValue = serializer.ConvertToType<string>(dictionary["answerValue"]);
                }

                // From the new version of the registrant portal:
                if (dictionary.ContainsKey("answerValues"))
                    obj.answerValues = serializer.ConvertToType<string[]>(dictionary["answerValues"]);

                if (dictionary.ContainsKey("answerId"))
                    obj.answerId = serializer.ConvertToType<string>(dictionary["answerId"]);

                return obj;
            }

            return null;
        }

        public override IDictionary<string, object> Serialize(
            object obj,
            JavaScriptSerializer serializer)
        {
            BprAnswer answer = (BprAnswer)obj;
            IDictionary<string, object> serialized = new Dictionary<string, object>();
            if (answer != null)
            {
                serialized["answerId"] = answer.answerId;
                if (string.IsNullOrEmpty(answer.answerValue))
                    serialized["answerValue"] = answer.answerValues;
                else
                    serialized["answerValue"] = answer.answerValue;
            }
            return serialized;
        }
    }
}